/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.modelmsg;

import android.graphics.Bitmap;
import com.tencent.mm.sdk.b.a;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage$IMediaObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class WXMediaMessage {
    private static final String TAG = "MicroMsg.SDK.WXMediaMessage";
    private static final int THUMB_LENGTH_LIMIT = 32768;
    private static final int TITLE_LENGTH_LIMIT = 512;
    private static final int DESCRIPTION_LENGTH_LIMIT = 1024;
    private static final int MEDIA_TAG_NAME_LENGTH_LIMIT = 64;
    public static final String ACTION_WXAPPMESSAGE = "com.tencent.mm.sdk.openapi.Intent.ACTION_WXAPPMESSAGE";
    public int sdkVer;
    public String title;
    public String description;
    public byte[] thumbData;
    public WXMediaMessage$IMediaObject mediaObject;
    public String mediaTagName;

    public WXMediaMessage() {
        this(null);
    }

    public WXMediaMessage(WXMediaMessage$IMediaObject wXMediaMessage$IMediaObject) {
        this.mediaObject = wXMediaMessage$IMediaObject;
    }

    public final int getType() {
        if (this.mediaObject == null) {
            return 0;
        }
        return this.mediaObject.type();
    }

    public final void setThumbImage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            a.a(TAG, "put thumb failed");
            return;
        }
    }

    final boolean checkArgs() {
        if (this.getType() == 8 && (this.thumbData == null || this.thumbData.length == 0)) {
            a.a(TAG, "checkArgs fail, thumbData should not be null when send emoji");
            return false;
        }
        if (this.thumbData != null && this.thumbData.length > 32768) {
            a.a(TAG, "checkArgs fail, thumbData is invalid");
            return false;
        }
        if (this.title != null && this.title.length() > 512) {
            a.a(TAG, "checkArgs fail, title is invalid");
            return false;
        }
        if (this.description != null && this.description.length() > 1024) {
            a.a(TAG, "checkArgs fail, description is invalid");
            return false;
        }
        if (this.mediaObject == null) {
            a.a(TAG, "checkArgs fail, mediaObject is null");
            return false;
        }
        if (this.mediaTagName != null && this.mediaTagName.length() > 64) {
            a.a(TAG, "checkArgs fail, mediaTagName is too long");
            return false;
        }
        return this.mediaObject.checkArgs();
    }
}

