/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.openapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.tencent.mm.sdk.a;
import com.tencent.mm.sdk.a.a$a;
import com.tencent.mm.sdk.a.a.b;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.modelmsg.GetMessageFromWX$Req;
import com.tencent.mm.sdk.modelmsg.LaunchFromWX$Req;
import com.tencent.mm.sdk.modelmsg.SendAuth$Resp;
import com.tencent.mm.sdk.modelmsg.SendMessageToWX$Resp;
import com.tencent.mm.sdk.modelmsg.ShowMessageFromWX$Req;
import com.tencent.mm.sdk.modelpay.PayResp;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.WXApiImplComm;

final class WXApiImplV10
implements IWXAPI {
    private static final String TAG = "MicroMsg.SDK.WXApiImplV10";
    private Context context;
    private String appId;
    private boolean checkSignature = false;
    private boolean detached = false;
    private static String wxappPayEntryClassname = null;

    WXApiImplV10(Context context, String string, boolean bl2) {
        com.tencent.mm.sdk.b.a.c(TAG, "<init>, appId = " + string + ", checkSignature = " + bl2);
        this.context = context;
        this.appId = string;
        this.checkSignature = bl2;
    }

    public final boolean registerApp(String object) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "register app failed for wechat app signature check failed");
            return false;
        }
        com.tencent.mm.sdk.b.a.c(TAG, "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        com.tencent.mm.sdk.b.a.c(TAG, "register app " + this.context.getPackageName());
        object = new com.tencent.mm.sdk.a.a.a$a();
        new com.tencent.mm.sdk.a.a.a$a().l = "com.tencent.mm";
        ((com.tencent.mm.sdk.a.a.a$a)object).m = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((com.tencent.mm.sdk.a.a.a$a)object).j = "weixin://registerapp?appid=" + this.appId;
        return com.tencent.mm.sdk.a.a.a.a(this.context, (com.tencent.mm.sdk.a.a.a$a)object);
    }

    public final void unregisterApp() {
        if (this.detached) {
            throw new IllegalStateException("unregisterApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "unregister app failed for wechat app signature check failed");
            return;
        }
        com.tencent.mm.sdk.b.a.c(TAG, "unregisterApp, appId = " + this.appId);
        if (this.appId == null || this.appId.length() == 0) {
            com.tencent.mm.sdk.b.a.a(TAG, "unregisterApp fail, appId is empty");
            return;
        }
        com.tencent.mm.sdk.b.a.c(TAG, "unregister app " + this.context.getPackageName());
        com.tencent.mm.sdk.a.a.a$a a$a = new com.tencent.mm.sdk.a.a.a$a();
        new com.tencent.mm.sdk.a.a.a$a().l = "com.tencent.mm";
        a$a.m = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER";
        a$a.j = "weixin://unregisterapp?appid=" + this.appId;
        com.tencent.mm.sdk.a.a.a.a(this.context, a$a);
    }

    public final boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        if (!WXApiImplComm.isIntentFromWx(object, "com.tencent.mm.openapi.token")) {
            com.tencent.mm.sdk.b.a.b(TAG, "handleIntent fail, intent not from weixin msg");
            return false;
        }
        if (this.detached) {
            throw new IllegalStateException("handleIntent fail, WXMsgImpl has been detached");
        }
        Object object2 = object.getStringExtra("_mmessage_content");
        int n2 = object.getIntExtra("_mmessage_sdkVersion", 0);
        String string = object.getStringExtra("_mmessage_appPackage");
        if (string == null || string.length() == 0) {
            com.tencent.mm.sdk.b.a.a(TAG, "invalid argument");
            return false;
        }
        byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
        if (!this.checkSumConsistent(byArray, (byte[])(object2 = (Object)b.a((String)object2, n2, string)))) {
            com.tencent.mm.sdk.b.a.a(TAG, "checksum fail");
            return false;
        }
        int n3 = object.getIntExtra("_wxapi_command_type", 0);
        switch (n3) {
            case 1: {
                object = new SendAuth$Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 2: {
                object = new SendMessageToWX$Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 3: {
                object = new GetMessageFromWX$Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
            case 4: {
                object = new ShowMessageFromWX$Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
            case 5: {
                object = new PayResp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 6: {
                object = new LaunchFromWX$Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
        }
        com.tencent.mm.sdk.b.a.a(TAG, "unknown cmd = " + n3);
        return false;
    }

    public final boolean isWXAppInstalled() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppInstalled fail, WXMsgImpl has been detached");
        }
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                return false;
            }
            return WXApiImplComm.validateAppSignature(this.context, packageInfo.signatures, this.checkSignature);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public final boolean isWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        return this.getWXAppSupportAPI() >= 0x22000001;
    }

    public final int getWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("getWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            com.tencent.mm.sdk.b.a.a(TAG, "open wx app failed, not installed or signature check failed");
            return 0;
        }
        return new a(this.context).getInt("_build_info_sdk_int_", 0);
    }

    public final boolean openWXApp() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            com.tencent.mm.sdk.b.a.a(TAG, "open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            com.tencent.mm.sdk.b.a.a(TAG, "startActivity fail, exception = " + exception.getMessage());
            return false;
        }
        return true;
    }

    public final boolean sendReq(BaseReq object) {
        if (this.detached) {
            throw new IllegalStateException("sendReq fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendReq failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseReq)object).checkArgs()) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendReq checkArgs fail");
            return false;
        }
        com.tencent.mm.sdk.b.a.c(TAG, "sendReq, req type = " + ((BaseReq)object).getType());
        Bundle bundle = new Bundle();
        ((BaseReq)object).toBundle(bundle);
        if (((BaseReq)object).getType() == 5) {
            return this.sendPayReq(this.context, bundle);
        }
        object = new a$a();
        new a$a().k = bundle;
        ((a$a)object).j = "weixin://sendreq?appid=" + this.appId;
        ((a$a)object).h = "com.tencent.mm";
        ((a$a)object).i = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return com.tencent.mm.sdk.a.a.a(this.context, (a$a)object);
    }

    private boolean sendPayReq(Context context, Bundle bundle) {
        if (wxappPayEntryClassname == null) {
            wxappPayEntryClassname = new a(context).getString("_wxapp_pay_entry_classname_", null);
            com.tencent.mm.sdk.b.a.c(TAG, "pay, set wxappPayEntryClassname = " + wxappPayEntryClassname);
            if (wxappPayEntryClassname == null) {
                com.tencent.mm.sdk.b.a.a(TAG, "pay fail, wxappPayEntryClassname is null");
                return false;
            }
        }
        a$a a$a = new a$a();
        new a$a().k = bundle;
        a$a.h = "com.tencent.mm";
        a$a.i = wxappPayEntryClassname;
        return com.tencent.mm.sdk.a.a.a(context, a$a);
    }

    public final boolean sendResp(BaseResp object) {
        if (this.detached) {
            throw new IllegalStateException("sendResp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseResp)object).checkArgs()) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendResp checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        ((BaseResp)object).toBundle(bundle);
        object = new a$a();
        new a$a().k = bundle;
        ((a$a)object).j = "weixin://sendresp?appid=" + this.appId;
        ((a$a)object).h = "com.tencent.mm";
        ((a$a)object).i = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return com.tencent.mm.sdk.a.a.a(this.context, (a$a)object);
    }

    public final void detach() {
        com.tencent.mm.sdk.b.a.c(TAG, "detach");
        this.detached = true;
        this.context = null;
    }

    private boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            com.tencent.mm.sdk.b.a.a(TAG, "checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            com.tencent.mm.sdk.b.a.a(TAG, "checkSumConsistent fail, length is different");
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }
}

