
package com.qihoo.gamecenter.sdk.demos.activity;

import com.qihoo.gamecenter.sdk.common.IDispatcherCallback;
import com.qihoo.gamecenter.sdk.demos.R;
import com.qihoo.gamecenter.sdk.demos.utils.ProgressUtil;
import com.qihoo.gamecenter.sdk.demos.utils.QihooUserInfo;
import com.qihoo.gamecenter.sdk.matrix.Matrix;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.TextView;
import android.widget.Toast;

public class PortraitSdkUserActivity extends SdkUserBaseActivity implements
        OnClickListener {
    private static final String TAG = "PortraitSdkUserActivity";

    private TextView mLoginResultView;

    private ProgressDialog mProgress;

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btn_login_choose:
                clearLoginResult();
                doSdkLogin(false);
                break;
            case R.id.btn_switch_account:
                doSdkSwitchAccount(false);
                break;
            case R.id.btn_upload_score:
                doSdkUploadScore(mQihooUserInfo);
                break;
            case R.id.btn_get_contact_content:
                doSdkGetContactContent(mQihooUserInfo, false);
                break;
            case R.id.btn_invite_friend_batch:
                doSdkInviteFriend(mQihooUserInfo, false);
                break;
            case R.id.btn_share:
                doSdkShare(mQihooUserInfo, false);
                break;
            case R.id.btn_logout:
                doSdkLogout(mQihooUserInfo);
                clearLoginResult();
                break;
            case R.id.btn_get_game_top_friend:
                doSdkGetRankFriend(mQihooUserInfo);
                break;
            case R.id.btn_get_game_top:
                doSdkGetGlobalRankList(mQihooUserInfo);
                break;
            case R.id.btn_invite_friend_by_sdk:
                doSdkInviteFriendBySdk(mQihooUserInfo, false);
                break;
            case R.id.btn_display_rank:
                doSdkDisplayGameFriendRank(mQihooUserInfo, false);
                break;
            case R.id.btn_get_user_info:
                doSdkGetUserInfo(mQihooUserInfo);
                break;
            case R.id.btn_bbs:
                doSdkBBS(mQihooUserInfo, false);
                break;
            case R.id.btn_quit:
                doSdkQuit(false);
                break;
            case R.id.btn_realnamereg:
                doSdkRealNameRegister(mQihooUserInfo, false);
                break;
            case R.id.btn_antAddiction:
                doSdkAntiAddictionQuery(mAccessToken, mQihooUserInfo);
                break;
            default:
                break;
        }

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sdk_user_activity);
        resetViews();
        mIsLandscape = false;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    private void resetViews() {
        TextView sdkVerView = (TextView) findViewById(R.id.sdk_ver);
        sdkVerView.setText(getString(R.string.sdk_ver).concat(Matrix.getVersionName(this)));

        TextView channelView = (TextView) findViewById(R.id.channel);
        channelView.setText(getString(R.string.channel).concat("default"/*Matrix.getChannel()*/));

        mLoginResultView = (TextView) findViewById(R.id.login_result);

        findViewById(R.id.btn_login_choose).setOnClickListener(this);
        findViewById(R.id.btn_switch_account).setOnClickListener(this);
        findViewById(R.id.btn_upload_score).setOnClickListener(this);
        findViewById(R.id.btn_get_contact_content).setOnClickListener(this);
        findViewById(R.id.btn_invite_friend_batch).setOnClickListener(this);
        findViewById(R.id.btn_share).setOnClickListener(this);
        findViewById(R.id.btn_logout).setOnClickListener(this);
        findViewById(R.id.btn_get_game_top_friend).setOnClickListener(this);
        findViewById(R.id.btn_get_game_top).setOnClickListener(this);
        findViewById(R.id.btn_invite_friend_by_sdk).setOnClickListener(this);
        findViewById(R.id.btn_display_rank).setOnClickListener(this);
        findViewById(R.id.btn_get_user_info).setOnClickListener(this);
        findViewById(R.id.btn_bbs).setOnClickListener(this);
        findViewById(R.id.btn_quit).setOnClickListener(this);
        findViewById(R.id.btn_realnamereg).setOnClickListener(this);
        findViewById(R.id.btn_antAddiction).setOnClickListener(this);
    }

    private void clearLoginResult() {
        mLoginResultView.setText(null);
        mQihooUserInfo = null;
    }

    @Override
    public void onGotUserInfo(QihooUserInfo userInfo) {
        ProgressUtil.dismiss(mProgress);

        if (userInfo != null && userInfo.isValid()) {
            // 保存QihooUserInfo
            mQihooUserInfo = userInfo;

            // 界面显示QihooUser的Id和Name
            mLoginResultView.setText(getLoginResultText());

        } else {
            Toast.makeText(this, R.string.get_user_fail, Toast.LENGTH_SHORT).show();
        }
    }

    private String getLoginResultText() {
        String result = "";
        if (mQihooUserInfo != null && mQihooUserInfo.isValid()) {
            result += ("Id=" + mQihooUserInfo.getId() + ", Name=" + mQihooUserInfo.getName()
                    + "avatar=" + mQihooUserInfo.getAvatar());
        }

        return result;
    }
}
