
package com.qihoo.gamecenter.sdk.demos.activity;


import com.qihoo.gamecenter.sdk.demos.R;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
/**
 * 第一个activity，提供横屏和竖屏游戏的入口
 */
public class SdkMainActivity extends Activity implements View.OnClickListener {

    private Button portraitBtn;
    private Button landscapeBtn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sdk_main_activity);
        portraitBtn = (Button) findViewById(R.id.btn_portrait_game);
        landscapeBtn = (Button) findViewById(R.id.btn_landscape_game);
        portraitBtn.setOnClickListener(this);
        landscapeBtn.setOnClickListener(this);
    }

    private void startPortraitSdkUserActivity() {
        Intent intent = new Intent(SdkMainActivity.this, PortraitSdkUserActivity.class);
        startActivity(intent);
    }

    private void startLandscapeSdkUserActivity() {
        Intent intent = new Intent(SdkMainActivity.this, LandscapeSdkUserActivity.class);
        startActivity(intent);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.btn_portrait_game) {
            startPortraitSdkUserActivity();
        } else if (v.getId() == R.id.btn_landscape_game) {
            startLandscapeSdkUserActivity();
        }
        this.finish();
    }

}
